%------------------------------------------------------------------------------
% File     : DAT171^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Huffman 1825
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Bla08] Blanchette (2008), The Textbook Proof of Huffman's Alg
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : huffman__1825.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.5.0, 0.33 v7.2.0, 0.25 v7.1.0
% Syntax   : Number of formulae    :  373 (  85 unt;  73 typ;   0 def)
%            Number of atoms       :  895 ( 326 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4389 (  58   ~;  17   |;  36   &;3880   @)
%                                         (   0 <=>; 398  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   7 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  120 ( 120   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   74 (  71 usr;   7 con; 0-6 aty)
%            Number of variables   :  967 (  31   ^; 868   !;   5   ?; 967   :)
%                                         (  63  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:43:13.642
%------------------------------------------------------------------------------
%----Could-be-implicit typings (5)
thf(ty_t_Huffman__Mirabelle__gjololrwrm_Otree,type,
    huffma16452318e_tree: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (68)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__ring,type,
    ordered_ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__mult,type,
    semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__semiring,type,
    ordered_semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__semiring__0,type,
    ordered_semiring_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oordered__comm__semiring,type,
    ordere1490568538miring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors__cancel,type,
    semiri1923998003cancel: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__monoid__add__imp__le,type,
    ordere516151231imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oalphabet,type,
    huffma505251170phabet: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( set @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OcachedWeight,type,
    huffma787811817Weight: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oconsistent,type,
    huffma1050891809istent: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > $o ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ocost,type,
    huffma636208924e_cost: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Odepth,type,
    huffma223349076_depth: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ofreq,type,
    huffma854352999e_freq: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oheight,type,
    huffma1554076246height: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OmergeSibling,type,
    huffma1954420889ibling: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ooptimum,type,
    huffma936049440ptimum: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > $o ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Osibling,type,
    huffma943100115ibling: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > A ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OsplitLeaf,type,
    huffma454997449itLeaf: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat > A > nat > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OswapFourSyms,type,
    huffma304375860urSyms: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > A > A > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OswapLeaves,type,
    huffma2094459102Leaves: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat > A > nat > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OswapSyms,type,
    huffma469337550apSyms: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OuniteTrees,type,
    huffma453905539eTrees: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oweight,type,
    huffma691733767weight: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a,type,
    a2: a ).

thf(sy_v_b,type,
    b: a ).

thf(sy_v_t,type,
    t: huffma16452318e_tree @ a ).

thf(sy_v_w_092_060_094sub_062a,type,
    w_a: nat ).

thf(sy_v_w_092_060_094sub_062b,type,
    w_b: nat ).

%----Relevant facts (254)
thf(fact_0_notin__alphabet__imp__splitLeaf__id,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,W_a: nat,W_b: nat,B: A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma454997449itLeaf @ A @ T @ W_a @ A2 @ W_b @ B )
        = T ) ) ).

% notin_alphabet_imp_splitLeaf_id
thf(fact_1_exists__in__alphabet,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
    ? [A3: A] : ( member @ A @ A3 @ ( huffma505251170phabet @ A @ T ) ) ).

% exists_in_alphabet
thf(fact_2_consistent__splitLeaf,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,B: A,W_a: nat,A2: A,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
       => ( huffma1050891809istent @ A @ ( huffma454997449itLeaf @ A @ T @ W_a @ A2 @ W_b @ B ) ) ) ) ).

% consistent_splitLeaf
thf(fact_3_freq__swapFourSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,C: A,D: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
         => ( ( member @ A @ C @ ( huffma505251170phabet @ A @ T ) )
           => ( ( member @ A @ D @ ( huffma505251170phabet @ A @ T ) )
             => ( ( huffma854352999e_freq @ A @ ( huffma304375860urSyms @ A @ T @ A2 @ B @ C @ D ) )
                = ( huffma854352999e_freq @ A @ T ) ) ) ) ) ) ) ).

% freq_swapFourSyms
thf(fact_4_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = ( plus_plus @ A @ A2 @ C ) )
          = ( B = C ) ) ) ).

% add_left_cancel
thf(fact_5_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = ( plus_plus @ A @ C @ A2 ) )
          = ( B = C ) ) ) ).

% add_right_cancel
thf(fact_6_weight__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( huffma854352999e_freq @ A @ T @ A2 ) ) @ ( huffma854352999e_freq @ A @ T @ B ) )
                  = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_a ) @ W_b ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( huffma854352999e_freq @ A @ T @ A2 ) )
                  = ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_b ) ) ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( huffma854352999e_freq @ A @ T @ B ) )
                  = ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_a ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
                  = ( huffma691733767weight @ A @ T ) ) ) ) ) ) ) ) ).

% weight_swapLeaves
thf(fact_7_freq__swapSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
         => ( ( huffma854352999e_freq @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) )
            = ( huffma854352999e_freq @ A @ T ) ) ) ) ) ).

% freq_swapSyms
thf(fact_8_freq__uniteTrees,axiom,
    ! [A: $tType,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma854352999e_freq @ A @ ( huffma453905539eTrees @ A @ T_1 @ T_2 ) )
      = ( ^ [A4: A] : ( plus_plus @ nat @ ( huffma854352999e_freq @ A @ T_1 @ A4 ) @ ( huffma854352999e_freq @ A @ T_2 @ A4 ) ) ) ) ).

% freq_uniteTrees
thf(fact_9_alphabet__swapFourSyms,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,B: A,C: A,D: A] :
      ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ C @ ( huffma505251170phabet @ A @ T ) )
         => ( ( member @ A @ D @ ( huffma505251170phabet @ A @ T ) )
           => ( ( huffma505251170phabet @ A @ ( huffma304375860urSyms @ A @ T @ A2 @ B @ C @ D ) )
              = ( huffma505251170phabet @ A @ T ) ) ) ) ) ) ).

% alphabet_swapFourSyms
thf(fact_10_swapLeaves__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma2094459102Leaves @ A @ T @ ( huffma854352999e_freq @ A @ T @ A2 ) @ A2 @ ( huffma854352999e_freq @ A @ T @ A2 ) @ A2 )
        = T ) ) ).

% swapLeaves_id
thf(fact_11_nat__add__left__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ K @ M )
        = ( plus_plus @ nat @ K @ N ) )
      = ( M = N ) ) ).

% nat_add_left_cancel
thf(fact_12_nat__add__right__cancel,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ K )
        = ( plus_plus @ nat @ N @ K ) )
      = ( M = N ) ) ).

% nat_add_right_cancel
thf(fact_13_consistent__swapFourSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,C: A,D: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( huffma1050891809istent @ A @ ( huffma304375860urSyms @ A @ T @ A2 @ B @ C @ D ) ) ) ).

% consistent_swapFourSyms
thf(fact_14_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_15_swapLeaves__id__when__notin__alphabet,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,W: nat,W2: nat] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma2094459102Leaves @ A @ T @ W @ A2 @ W2 @ A2 )
        = T ) ) ).

% swapLeaves_id_when_notin_alphabet
thf(fact_16_alphabet__swapSyms,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,B: A] :
      ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
       => ( ( huffma505251170phabet @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) )
          = ( huffma505251170phabet @ A @ T ) ) ) ) ).

% alphabet_swapSyms
thf(fact_17_swapSyms__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma469337550apSyms @ A @ T @ A2 @ A2 )
        = T ) ) ).

% swapSyms_id
thf(fact_18_swapFourSyms__def,axiom,
    ! [A: $tType] :
      ( ( huffma304375860urSyms @ A )
      = ( ^ [T2: huffma16452318e_tree @ A,A4: A,B2: A,C2: A,D2: A] : ( if @ ( huffma16452318e_tree @ A ) @ ( A4 = D2 ) @ ( huffma469337550apSyms @ A @ T2 @ B2 @ C2 ) @ ( if @ ( huffma16452318e_tree @ A ) @ ( B2 = C2 ) @ ( huffma469337550apSyms @ A @ T2 @ A4 @ D2 ) @ ( huffma469337550apSyms @ A @ ( huffma469337550apSyms @ A @ T2 @ A4 @ C2 ) @ B2 @ D2 ) ) ) ) ) ).

% swapFourSyms_def
thf(fact_19_swapSyms__def,axiom,
    ! [A: $tType] :
      ( ( huffma469337550apSyms @ A )
      = ( ^ [T2: huffma16452318e_tree @ A,A4: A,B2: A] : ( huffma2094459102Leaves @ A @ T2 @ ( huffma854352999e_freq @ A @ T2 @ A4 ) @ A4 @ ( huffma854352999e_freq @ A @ T2 @ B2 ) @ B2 ) ) ) ).

% swapSyms_def
thf(fact_20_consistent__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,W_a: nat,A2: A,W_b: nat,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( huffma1050891809istent @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) ) ).

% consistent_swapLeaves
thf(fact_21_consistent__swapSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( huffma1050891809istent @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) ) ) ).

% consistent_swapSyms
thf(fact_22_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = ( plus_plus @ A @ C @ A2 ) )
         => ( B = C ) ) ) ).

% add_right_imp_eq
thf(fact_23_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = ( plus_plus @ A @ A2 @ C ) )
         => ( B = C ) ) ) ).

% add_left_imp_eq
thf(fact_24_add_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( plus_plus @ A @ B @ ( plus_plus @ A @ A2 @ C ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% add.left_commute
thf(fact_25_add_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A4: A,B2: A] : ( plus_plus @ A @ B2 @ A4 ) ) ) ) ).

% add.commute
thf(fact_26_add_Oright__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = ( plus_plus @ A @ C @ A2 ) )
          = ( B = C ) ) ) ).

% add.right_cancel
thf(fact_27_add_Oleft__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = ( plus_plus @ A @ A2 @ C ) )
          = ( B = C ) ) ) ).

% add.left_cancel
thf(fact_28_add_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% add.assoc
thf(fact_29_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( K = L ) )
         => ( ( plus_plus @ A @ I @ K )
            = ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_30_freq__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B )
       => ( ( huffma854352999e_freq @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
          = ( ^ [C2: A] : ( if @ nat @ ( C2 = A2 ) @ ( if @ nat @ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) ) @ W_a @ ( zero_zero @ nat ) ) @ ( if @ nat @ ( C2 = B ) @ ( if @ nat @ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) ) @ W_b @ ( zero_zero @ nat ) ) @ ( huffma854352999e_freq @ A @ T @ C2 ) ) ) ) ) ) ) ).

% freq_swapLeaves
thf(fact_31_sibling__swapFourSyms__when__4th__is__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,C: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
         => ( ( member @ A @ C @ ( huffma505251170phabet @ A @ T ) )
           => ( ( A2 != B )
             => ( ( ( huffma943100115ibling @ A @ T @ C )
                 != C )
               => ( ( huffma943100115ibling @ A @ ( huffma304375860urSyms @ A @ T @ A2 @ B @ C @ ( huffma943100115ibling @ A @ T @ C ) ) @ A2 )
                  = B ) ) ) ) ) ) ) ).

% sibling_swapFourSyms_when_4th_is_sibling
thf(fact_32_depth__swapSyms__neither,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,C: A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( C != A2 )
       => ( ( C != B )
         => ( ( huffma223349076_depth @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) @ C )
            = ( huffma223349076_depth @ A @ T @ C ) ) ) ) ) ).

% depth_swapSyms_neither
thf(fact_33_depth__swapLeaves__neither,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,C: A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( C != A2 )
       => ( ( C != B )
         => ( ( huffma223349076_depth @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) @ C )
            = ( huffma223349076_depth @ A @ T @ C ) ) ) ) ) ).

% depth_swapLeaves_neither
thf(fact_34_sibling__swapSyms__other__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,B: A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ B )
         != A2 )
       => ( ( ( huffma943100115ibling @ A @ T @ B )
           != B )
         => ( ( A2 != B )
           => ( ( huffma943100115ibling @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) @ ( huffma943100115ibling @ A @ T @ B ) )
              = A2 ) ) ) ) ) ).

% sibling_swapSyms_other_sibling
thf(fact_35_sibling__swapSyms__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,B: A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ B )
         != B )
       => ( ( A2 != B )
         => ( ( huffma943100115ibling @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ ( huffma943100115ibling @ A @ T @ B ) ) @ A2 )
            = B ) ) ) ) ).

% sibling_swapSyms_sibling
thf(fact_36_sibling__swapLeaves__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,B: A,A2: A,W_a: nat,W_s: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ B )
         != B )
       => ( ( A2 != B )
         => ( ( huffma943100115ibling @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_s @ ( huffma943100115ibling @ A @ T @ B ) ) @ A2 )
            = B ) ) ) ) ).

% sibling_swapLeaves_sibling
thf(fact_37_semiring__normalization__rules_I20_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ ( plus_plus @ A @ C @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ D ) ) ) ) ).

% semiring_normalization_rules(20)
thf(fact_38_semiring__normalization__rules_I21_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% semiring_normalization_rules(21)
thf(fact_39_semiring__normalization__rules_I22_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C @ D ) )
          = ( plus_plus @ A @ C @ ( plus_plus @ A @ A2 @ D ) ) ) ) ).

% semiring_normalization_rules(22)
thf(fact_40_add_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.left_neutral
thf(fact_41_add_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.right_neutral
thf(fact_42_double__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( plus_plus @ A @ A2 @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero
thf(fact_43_double__zero__sym,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ A2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero_sym
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A5 ) )
      = A5 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P @ X2 )
          = ( Q @ X2 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B3: $tType,A: $tType,F: A > B3,G: A > B3] :
      ( ! [X2: A] :
          ( ( F @ X2 )
          = ( G @ X2 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_add__cancel__left__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ( plus_plus @ A @ B @ A2 )
            = A2 )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_left
thf(fact_49_add__cancel__left__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( plus_plus @ A @ A2 @ B )
            = A2 )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_right
thf(fact_50_add__cancel__right__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
            = ( plus_plus @ A @ B @ A2 ) )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_left
thf(fact_51_add__cancel__right__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
            = ( plus_plus @ A @ A2 @ B ) )
          = ( B
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_right
thf(fact_52_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_53_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_54_notin__alphabet__imp__sibling__id,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma943100115ibling @ A @ T @ A2 )
        = A2 ) ) ).

% notin_alphabet_imp_sibling_id
thf(fact_55_sibling__sibling__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma943100115ibling @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) )
        = A2 ) ) ).

% sibling_sibling_id
thf(fact_56_notin__alphabet__imp__freq__0,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma854352999e_freq @ A @ T @ A2 )
        = ( zero_zero @ nat ) ) ) ).

% notin_alphabet_imp_freq_0
thf(fact_57_depth__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma223349076_depth @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) )
        = ( huffma223349076_depth @ A @ T @ A2 ) ) ) ).

% depth_sibling
thf(fact_58_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A @ ( type2 @ A ) )
     => ! [X3: A] :
          ( ( ( zero_zero @ A )
            = X3 )
          = ( X3
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_59_semiring__normalization__rules_I6_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% semiring_normalization_rules(6)
thf(fact_60_semiring__normalization__rules_I5_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% semiring_normalization_rules(5)
thf(fact_61_add__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( B
            = ( plus_plus @ A @ B @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% add_0_iff
thf(fact_62_comm__monoid__add__class_Oadd__0,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_add_class.add_0
thf(fact_63_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.comm_neutral
thf(fact_64_add_Ogroup__left__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.group_left_neutral
thf(fact_65_add__eq__0__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ( plus_plus @ A @ X3 @ Y )
            = ( zero_zero @ A ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_66_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus @ nat @ ( zero_zero @ nat ) @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_67_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = M )
     => ( N
        = ( zero_zero @ nat ) ) ) ).

% add_eq_self_zero
thf(fact_68_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( ( huffma943100115ibling @ A @ T @ A2 )
       != A2 )
     => ( member @ A @ ( huffma943100115ibling @ A @ T @ A2 ) @ ( huffma505251170phabet @ A @ T ) ) ) ).

% sibling_ne_imp_sibling_in_alphabet
thf(fact_69_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( member @ A @ ( huffma943100115ibling @ A @ T @ A2 ) @ ( huffma505251170phabet @ A @ T ) ) ) ).

% in_alphabet_imp_sibling_in_alphabet
thf(fact_70_sibling__reciprocal,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ A2 )
          = B )
       => ( ( huffma943100115ibling @ A @ T @ B )
          = A2 ) ) ) ).

% sibling_reciprocal
thf(fact_71_semiring__normalization__rules_I25_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C ) @ D ) ) ) ).

% semiring_normalization_rules(25)
thf(fact_72_semiring__normalization__rules_I24_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A4: A,C2: A] : ( plus_plus @ A @ C2 @ A4 ) ) ) ) ).

% semiring_normalization_rules(24)
thf(fact_73_semiring__normalization__rules_I23_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C ) @ B ) ) ) ).

% semiring_normalization_rules(23)
thf(fact_74_freq__mergeSibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( ( huffma943100115ibling @ A @ T @ A2 )
           != A2 )
         => ( ( huffma854352999e_freq @ A @ ( huffma1954420889ibling @ A @ T @ A2 ) )
            = ( ^ [C2: A] :
                  ( if @ nat @ ( C2 = A2 ) @ ( plus_plus @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma854352999e_freq @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) ) )
                  @ ( if @ nat
                    @ ( C2
                      = ( huffma943100115ibling @ A @ T @ A2 ) )
                    @ ( zero_zero @ nat )
                    @ ( huffma854352999e_freq @ A @ T @ C2 ) ) ) ) ) ) ) ) ).

% freq_mergeSibling
thf(fact_75_exists__at__height,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( huffma1050891809istent @ A @ T )
     => ? [X2: A] :
          ( ( member @ A @ X2 @ ( huffma505251170phabet @ A @ T ) )
          & ( ( huffma223349076_depth @ A @ T @ X2 )
            = ( huffma1554076246height @ A @ T ) ) ) ) ).

% exists_at_height
thf(fact_76_cost__swapSyms,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
         => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ B ) ) )
            = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ B ) ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) ) ) ) ).

% cost_swapSyms
thf(fact_77_cost__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ B ) ) )
                  = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_a @ ( huffma223349076_depth @ A @ T @ B ) ) ) @ ( times_times @ nat @ W_b @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) )
                  = ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_b @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B ) @ ( huffma223349076_depth @ A @ T @ B ) ) )
                  = ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_a @ ( huffma223349076_depth @ A @ T @ B ) ) ) ) )
              & ( ~ ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
               => ( ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
                  = ( huffma636208924e_cost @ A @ T ) ) ) ) ) ) ) ) ).

% cost_swapLeaves
thf(fact_78_cost__swapSyms__le,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
       => ( ( member @ A @ B @ ( huffma505251170phabet @ A @ T ) )
         => ( ( ord_less_eq @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma854352999e_freq @ A @ T @ B ) )
           => ( ( ord_less_eq @ nat @ ( huffma223349076_depth @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ B ) )
             => ( ord_less_eq @ nat @ ( huffma636208924e_cost @ A @ ( huffma469337550apSyms @ A @ T @ A2 @ B ) ) @ ( huffma636208924e_cost @ A @ T ) ) ) ) ) ) ) ).

% cost_swapSyms_le
thf(fact_79_zero__natural_Orsp,axiom,
    ( ( zero_zero @ nat )
    = ( zero_zero @ nat ) ) ).

% zero_natural.rsp
thf(fact_80_height__0__imp__sibling__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma943100115ibling @ A @ T @ A2 )
        = A2 ) ) ).

% height_0_imp_sibling_id
thf(fact_81_is__num__normalize_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% is_num_normalize(1)
thf(fact_82_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_83_add__le__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) )
          = ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_cancel_right
thf(fact_84_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) )
          = ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_cancel_left
thf(fact_85_le0,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% le0
thf(fact_86_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_87_mult__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ K )
        = ( times_times @ nat @ N @ K ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel2
thf(fact_88_mult__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel1
thf(fact_89_mult__0__right,axiom,
    ! [M: nat] :
      ( ( times_times @ nat @ M @ ( zero_zero @ nat ) )
      = ( zero_zero @ nat ) ) ).

% mult_0_right
thf(fact_90_mult__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% mult_is_0
thf(fact_91_notin__alphabet__imp__mergeSibling__id,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma1954420889ibling @ A @ T @ A2 )
        = T ) ) ).

% notin_alphabet_imp_mergeSibling_id
thf(fact_92_height__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,W_a: nat,A2: A,W_b: nat,B: A] :
      ( ( huffma1554076246height @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B ) )
      = ( huffma1554076246height @ A @ T ) ) ).

% height_swapLeaves
thf(fact_93_weight__mergeSibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma691733767weight @ A @ ( huffma1954420889ibling @ A @ T @ A2 ) )
      = ( huffma691733767weight @ A @ T ) ) ).

% weight_mergeSibling
thf(fact_94_add__le__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ B @ A2 ) @ B )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel1
thf(fact_95_add__le__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ B ) @ B )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel2
thf(fact_96_le__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ A2 @ B ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% le_add_same_cancel1
thf(fact_97_le__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ B @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% le_add_same_cancel2
thf(fact_98_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_le_zero_iff_single_add_le_zero
thf(fact_99_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_le_double_add_iff_zero_le_single_add
thf(fact_100_height__0__imp__cost__0,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma636208924e_cost @ A @ T )
        = ( zero_zero @ nat ) ) ) ).

% height_0_imp_cost_0
thf(fact_101_semiring__normalization__rules_I7_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A4: A,B2: A] : ( times_times @ A @ B2 @ A4 ) ) ) ) ).

% semiring_normalization_rules(7)
thf(fact_102_semiring__normalization__rules_I13_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ ( times_times @ A @ Ly @ Ry ) ) ) ) ).

% semiring_normalization_rules(13)
thf(fact_103_semiring__normalization__rules_I14_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ ( times_times @ A @ Rx @ Ry ) ) ) ) ) ).

% semiring_normalization_rules(14)
thf(fact_104_semiring__normalization__rules_I15_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Ry ) ) ) ) ).

% semiring_normalization_rules(15)
thf(fact_105_semiring__normalization__rules_I16_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ly ) ) ) ).

% semiring_normalization_rules(16)
thf(fact_106_semiring__normalization__rules_I17_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ Rx ) ) ) ) ).

% semiring_normalization_rules(17)
thf(fact_107_semiring__normalization__rules_I18_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ry ) ) ) ).

% semiring_normalization_rules(18)
thf(fact_108_semiring__normalization__rules_I19_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ Lx @ Ry ) ) ) ) ).

% semiring_normalization_rules(19)
thf(fact_109_le__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type2 @ A ) )
     => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% le_numeral_extra(3)
thf(fact_110_le__le__imp__sum__mult__le__sum__mult,axiom,
    ! [I: nat,J: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ M @ N )
       => ( ord_less_eq @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ N ) @ ( times_times @ nat @ J @ M ) ) @ ( plus_plus @ nat @ ( times_times @ nat @ I @ M ) @ ( times_times @ nat @ J @ N ) ) ) ) ) ).

% le_le_imp_sum_mult_le_sum_mult
thf(fact_111_mult_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( times_times @ A @ B @ ( times_times @ A @ A2 @ C ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% mult.left_commute
thf(fact_112_mult_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A4: A,B2: A] : ( times_times @ A @ B2 @ A4 ) ) ) ) ).

% mult.commute
thf(fact_113_mult_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% mult.assoc
thf(fact_114_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_115_mult__le__mono2,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( times_times @ nat @ K @ I ) @ ( times_times @ nat @ K @ J ) ) ) ).

% mult_le_mono2
thf(fact_116_mult__le__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( times_times @ nat @ I @ K ) @ ( times_times @ nat @ J @ K ) ) ) ).

% mult_le_mono1
thf(fact_117_mult__le__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ K @ L )
       => ( ord_less_eq @ nat @ ( times_times @ nat @ I @ K ) @ ( times_times @ nat @ J @ L ) ) ) ) ).

% mult_le_mono
thf(fact_118_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_119_le__square,axiom,
    ! [M: nat] : ( ord_less_eq @ nat @ M @ ( times_times @ nat @ M @ M ) ) ).

% le_square
thf(fact_120_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_121_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I @ K ) ) ) ).

% le_trans
thf(fact_122_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_123_le__cube,axiom,
    ! [M: nat] : ( ord_less_eq @ nat @ M @ ( times_times @ nat @ M @ ( times_times @ nat @ M @ M ) ) ) ).

% le_cube
thf(fact_124_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_125_depth__le__height,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] : ( ord_less_eq @ nat @ ( huffma223349076_depth @ A @ T @ A2 ) @ ( huffma1554076246height @ A @ T ) ) ).

% depth_le_height
thf(fact_126_semiring__normalization__rules_I10_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(10)
thf(fact_127_semiring__normalization__rules_I9_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(9)
thf(fact_128_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ( A2 != B )
            & ( C != D ) )
          = ( ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) )
           != ( plus_plus @ A @ ( times_times @ A @ A2 @ D ) @ ( times_times @ A @ B @ C ) ) ) ) ) ).

% crossproduct_noteq
thf(fact_129_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [W: A,Y: A,X3: A,Z: A] :
          ( ( ( plus_plus @ A @ ( times_times @ A @ W @ Y ) @ ( times_times @ A @ X3 @ Z ) )
            = ( plus_plus @ A @ ( times_times @ A @ W @ Z ) @ ( times_times @ A @ X3 @ Y ) ) )
          = ( ( W = X3 )
            | ( Y = Z ) ) ) ) ).

% crossproduct_eq
thf(fact_130_semiring__normalization__rules_I1_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,M: A,B: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A2 @ M ) @ ( times_times @ A @ B @ M ) )
          = ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ M ) ) ) ).

% semiring_normalization_rules(1)
thf(fact_131_semiring__normalization__rules_I8_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% semiring_normalization_rules(8)
thf(fact_132_semiring__normalization__rules_I34_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z: A] :
          ( ( times_times @ A @ X3 @ ( plus_plus @ A @ Y @ Z ) )
          = ( plus_plus @ A @ ( times_times @ A @ X3 @ Y ) @ ( times_times @ A @ X3 @ Z ) ) ) ) ).

% semiring_normalization_rules(34)
thf(fact_133_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [X3: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X3 ) ) ).

% zero_le
thf(fact_134_add__le__imp__le__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) )
         => ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_imp_le_right
thf(fact_135_add__le__imp__le__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) )
         => ( ord_less_eq @ A @ A2 @ B ) ) ) ).

% add_le_imp_le_left
thf(fact_136_le__iff__add,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B2: A] :
            ? [C2: A] :
              ( B2
              = ( plus_plus @ A @ A4 @ C2 ) ) ) ) ) ).

% le_iff_add
thf(fact_137_add__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% add_right_mono
thf(fact_138_add__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) ) ) ) ).

% add_left_mono
thf(fact_139_add__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ C @ D )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ D ) ) ) ) ) ).

% add_mono
thf(fact_140_add__mono__thms__linordered__semiring_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( ord_less_eq @ A @ K @ L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(1)
thf(fact_141_add__mono__thms__linordered__semiring_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( ord_less_eq @ A @ K @ L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(2)
thf(fact_142_add__mono__thms__linordered__semiring_I3_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type2 @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( K = L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(3)
thf(fact_143_mult__0,axiom,
    ! [N: nat] :
      ( ( times_times @ nat @ ( zero_zero @ nat ) @ N )
      = ( zero_zero @ nat ) ) ).

% mult_0
thf(fact_144_add__mult__distrib2,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( times_times @ nat @ K @ ( plus_plus @ nat @ M @ N ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) ) ) ).

% add_mult_distrib2
thf(fact_145_add__mult__distrib,axiom,
    ! [M: nat,N: nat,K: nat] :
      ( ( times_times @ nat @ ( plus_plus @ nat @ M @ N ) @ K )
      = ( plus_plus @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) ) ) ).

% add_mult_distrib
thf(fact_146_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq @ nat @ N @ ( zero_zero @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% le_0_eq
thf(fact_147_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% less_eq_nat.simps(1)
thf(fact_148_nat__le__iff__add,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M2: nat,N2: nat] :
        ? [K2: nat] :
          ( N2
          = ( plus_plus @ nat @ M2 @ K2 ) ) ) ) ).

% nat_le_iff_add
thf(fact_149_trans__le__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ M @ J ) ) ) ).

% trans_le_add2
thf(fact_150_trans__le__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ J @ M ) ) ) ).

% trans_le_add1
thf(fact_151_add__le__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ K ) ) ) ).

% add_le_mono1
thf(fact_152_add__le__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ K @ L )
       => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ L ) ) ) ) ).

% add_le_mono
thf(fact_153_le__Suc__ex,axiom,
    ! [K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ K @ L )
     => ? [N3: nat] :
          ( L
          = ( plus_plus @ nat @ K @ N3 ) ) ) ).

% le_Suc_ex
thf(fact_154_add__leD2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ K @ N ) ) ).

% add_leD2
thf(fact_155_add__leD1,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% add_leD1
thf(fact_156_le__add2,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ M @ N ) ) ).

% le_add2
thf(fact_157_le__add1,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ N @ M ) ) ).

% le_add1
thf(fact_158_add__leE,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ~ ( ( ord_less_eq @ nat @ M @ N )
         => ~ ( ord_less_eq @ nat @ K @ N ) ) ) ).

% add_leE
thf(fact_159_consistent__mergeSibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( huffma1050891809istent @ A @ ( huffma1954420889ibling @ A @ T @ A2 ) ) ) ).

% consistent_mergeSibling
thf(fact_160_add__scale__eq__noteq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type2 @ A ) )
     => ! [R: A,A2: A,B: A,C: A,D: A] :
          ( ( R
           != ( zero_zero @ A ) )
         => ( ( ( A2 = B )
              & ( C != D ) )
           => ( ( plus_plus @ A @ A2 @ ( times_times @ A @ R @ C ) )
             != ( plus_plus @ A @ B @ ( times_times @ A @ R @ D ) ) ) ) ) ) ).

% add_scale_eq_noteq
thf(fact_161_add__decreasing,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ B ) ) ) ) ).

% add_decreasing
thf(fact_162_add__increasing,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ B @ ( plus_plus @ A @ A2 @ C ) ) ) ) ) ).

% add_increasing
thf(fact_163_add__decreasing2,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less_eq @ A @ C @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ B ) ) ) ) ).

% add_decreasing2
thf(fact_164_add__increasing2,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
         => ( ( ord_less_eq @ A @ B @ A2 )
           => ( ord_less_eq @ A @ B @ ( plus_plus @ A @ A2 @ C ) ) ) ) ) ).

% add_increasing2
thf(fact_165_add__nonneg__nonneg,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ B ) ) ) ) ) ).

% add_nonneg_nonneg
thf(fact_166_add__nonpos__nonpos,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ) ).

% add_nonpos_nonpos
thf(fact_167_add__nonneg__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ X3 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ Y )
           => ( ( ( plus_plus @ A @ X3 @ Y )
                = ( zero_zero @ A ) )
              = ( ( X3
                  = ( zero_zero @ A ) )
                & ( Y
                  = ( zero_zero @ A ) ) ) ) ) ) ) ).

% add_nonneg_eq_0_iff
thf(fact_168_add__nonpos__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ Y @ ( zero_zero @ A ) )
           => ( ( ( plus_plus @ A @ X3 @ Y )
                = ( zero_zero @ A ) )
              = ( ( X3
                  = ( zero_zero @ A ) )
                & ( Y
                  = ( zero_zero @ A ) ) ) ) ) ) ) ).

% add_nonpos_eq_0_iff
thf(fact_169_cost__mergeSibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ A2 )
         != A2 )
       => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma1954420889ibling @ A @ T @ A2 ) ) @ ( huffma854352999e_freq @ A @ T @ A2 ) ) @ ( huffma854352999e_freq @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) ) )
          = ( huffma636208924e_cost @ A @ T ) ) ) ) ).

% cost_mergeSibling
thf(fact_170_optimum__def,axiom,
    ! [A: $tType] :
      ( ( huffma936049440ptimum @ A )
      = ( ^ [T2: huffma16452318e_tree @ A] :
          ! [U: huffma16452318e_tree @ A] :
            ( ( huffma1050891809istent @ A @ U )
           => ( ( ( huffma505251170phabet @ A @ T2 )
                = ( huffma505251170phabet @ A @ U ) )
             => ( ( ( huffma854352999e_freq @ A @ T2 )
                  = ( huffma854352999e_freq @ A @ U ) )
               => ( ord_less_eq @ nat @ ( huffma636208924e_cost @ A @ T2 ) @ ( huffma636208924e_cost @ A @ U ) ) ) ) ) ) ) ).

% optimum_def
thf(fact_171_mult__zero__left,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_left
thf(fact_172_mult__zero__right,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_right
thf(fact_173_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% mult_eq_0_iff
thf(fact_174_mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ( times_times @ A @ C @ A2 )
            = ( times_times @ A @ C @ B ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_left
thf(fact_175_mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ( times_times @ A @ A2 @ C )
            = ( times_times @ A @ B @ C ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_right
thf(fact_176_mult__not__zero,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
           != ( zero_zero @ A ) )
         => ( ( A2
             != ( zero_zero @ A ) )
            & ( B
             != ( zero_zero @ A ) ) ) ) ) ).

% mult_not_zero
thf(fact_177_divisors__zero,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
         => ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divisors_zero
thf(fact_178_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( B
             != ( zero_zero @ A ) )
           => ( ( times_times @ A @ A2 @ B )
             != ( zero_zero @ A ) ) ) ) ) ).

% no_zero_divisors
thf(fact_179_mult__left__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ C @ A2 )
              = ( times_times @ A @ C @ B ) )
            = ( A2 = B ) ) ) ) ).

% mult_left_cancel
thf(fact_180_mult__right__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ A2 @ C )
              = ( times_times @ A @ B @ C ) )
            = ( A2 = B ) ) ) ) ).

% mult_right_cancel
thf(fact_181_combine__common__factor,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,E: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A2 @ E ) @ ( plus_plus @ A @ ( times_times @ A @ B @ E ) @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ E ) @ C ) ) ) ).

% combine_common_factor
thf(fact_182_distrib__right,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% distrib_right
thf(fact_183_distrib__left,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ A2 @ ( plus_plus @ A @ B @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ B ) @ ( times_times @ A @ A2 @ C ) ) ) ) ).

% distrib_left
thf(fact_184_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( ( comm_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% comm_semiring_class.distrib
thf(fact_185_ring__class_Oring__distribs_I1_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ A2 @ ( plus_plus @ A @ B @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ B ) @ ( times_times @ A @ A2 @ C ) ) ) ) ).

% ring_class.ring_distribs(1)
thf(fact_186_ring__class_Oring__distribs_I2_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% ring_class.ring_distribs(2)
thf(fact_187_mult__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ C @ D )
           => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
             => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
               => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) ) ) ) ) ) ) ).

% mult_mono
thf(fact_188_mult__mono_H,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ C @ D )
           => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
             => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
               => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) ) ) ) ) ) ) ).

% mult_mono'
thf(fact_189_zero__le__square,axiom,
    ! [A: $tType] :
      ( ( linordered_ring @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ A2 ) ) ) ).

% zero_le_square
thf(fact_190_split__mult__pos__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) ) )
         => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) ) ) ) ).

% split_mult_pos_le
thf(fact_191_mult__left__mono__neg,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) ) ) ) ) ).

% mult_left_mono_neg
thf(fact_192_mult__nonpos__nonpos,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) ) ) ) ) ).

% mult_nonpos_nonpos
thf(fact_193_mult__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less_eq @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) ) ) ) ) ).

% mult_left_mono
thf(fact_194_mult__right__mono__neg,axiom,
    ! [A: $tType] :
      ( ( ordered_ring @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ) ).

% mult_right_mono_neg
thf(fact_195_mult__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ) ).

% mult_right_mono
thf(fact_196_mult__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) )
          = ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) ) ) ) ).

% mult_le_0_iff
thf(fact_197_split__mult__neg__le,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) ) )
         => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ).

% split_mult_neg_le
thf(fact_198_mult__nonneg__nonneg,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) ) ) ) ) ).

% mult_nonneg_nonneg
thf(fact_199_mult__nonneg__nonpos,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_nonneg_nonpos
thf(fact_200_mult__nonpos__nonneg,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ B )
           => ( ord_less_eq @ A @ ( times_times @ A @ A2 @ B ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_nonpos_nonneg
thf(fact_201_mult__nonneg__nonpos2,axiom,
    ! [A: $tType] :
      ( ( ordered_semiring_0 @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less_eq @ A @ B @ ( zero_zero @ A ) )
           => ( ord_less_eq @ A @ ( times_times @ A @ B @ A2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_nonneg_nonpos2
thf(fact_202_zero__le__mult__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B ) )
          = ( ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less_eq @ A @ ( zero_zero @ A ) @ B ) )
            | ( ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less_eq @ A @ B @ ( zero_zero @ A ) ) ) ) ) ) ).

% zero_le_mult_iff
thf(fact_203_ordered__comm__semiring__class_Ocomm__mult__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere1490568538miring @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ C )
           => ( ord_less_eq @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) ) ) ) ) ).

% ordered_comm_semiring_class.comm_mult_left_mono
thf(fact_204_sum__squares__ge__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_ring @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ ( times_times @ A @ X3 @ X3 ) @ ( times_times @ A @ Y @ Y ) ) ) ) ).

% sum_squares_ge_zero
thf(fact_205_sum__squares__le__zero__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ ( times_times @ A @ X3 @ X3 ) @ ( times_times @ A @ Y @ Y ) ) @ ( zero_zero @ A ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% sum_squares_le_zero_iff
thf(fact_206_height__0__imp__cachedWeight__eq__weight,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma787811817Weight @ A @ T )
        = ( huffma691733767weight @ A @ T ) ) ) ).

% height_0_imp_cachedWeight_eq_weight
thf(fact_207_sum__squares__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ( plus_plus @ A @ ( times_times @ A @ X3 @ X3 ) @ ( times_times @ A @ Y @ Y ) )
            = ( zero_zero @ A ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% sum_squares_eq_zero_iff
thf(fact_208_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A] : ( ord_less_eq @ A @ X3 @ X3 ) ) ).

% order_refl
thf(fact_209_left__add__mult__distrib,axiom,
    ! [I: nat,U2: nat,J: nat,K: nat] :
      ( ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ K ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ ( plus_plus @ nat @ I @ J ) @ U2 ) @ K ) ) ).

% left_add_mult_distrib
thf(fact_210_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B )
           => ( A2 = B ) ) ) ) ).

% dual_order.antisym
thf(fact_211_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B @ A2 )
         => ( ( ord_less_eq @ A @ C @ B )
           => ( ord_less_eq @ A @ C @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_212_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B: A] :
          ( ! [A3: A,B4: A] :
              ( ( ord_less_eq @ A @ A3 @ B4 )
             => ( P @ A3 @ B4 ) )
         => ( ! [A3: A,B4: A] :
                ( ( P @ B4 @ A3 )
               => ( P @ A3 @ B4 ) )
           => ( P @ A2 @ B ) ) ) ) ).

% linorder_wlog
thf(fact_213_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_214_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X3 @ Z ) ) ) ) ).

% order_trans
thf(fact_215_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ A2 )
           => ( A2 = B ) ) ) ) ).

% order_class.order.antisym
thf(fact_216_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( B = C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_217_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( A2 = B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_218_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X3: A] :
          ( ( ord_less_eq @ A @ Y @ X3 )
         => ( ( ord_less_eq @ A @ X3 @ Y )
            = ( X3 = Y ) ) ) ) ).

% antisym_conv
thf(fact_219_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X3 @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X3 )
             => ~ ( ord_less_eq @ A @ X3 @ Z ) )
           => ( ( ( ord_less_eq @ A @ X3 @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X3 ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X3 ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X3 )
                     => ~ ( ord_less_eq @ A @ X3 @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_220_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ A @ B @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% order.trans
thf(fact_221_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X3 @ Y )
         => ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% le_cases
thf(fact_222_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( X3 = Y )
         => ( ord_less_eq @ A @ X3 @ Y ) ) ) ).

% eq_refl
thf(fact_223_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
          | ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% linear
thf(fact_224_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ Y @ X3 )
           => ( X3 = Y ) ) ) ) ).

% antisym
thf(fact_225_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y2: A,Z2: A] : ( Y2 = Z2 ) )
        = ( ^ [X: A,Y3: A] :
              ( ( ord_less_eq @ A @ X @ Y3 )
              & ( ord_less_eq @ A @ Y3 @ X ) ) ) ) ) ).

% eq_iff
thf(fact_226_ord__le__eq__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 @ ( type2 @ B3 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B: A,F: A > B3,C: B3] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ( F @ B )
              = C )
           => ( ! [X2: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y4 )
                 => ( ord_less_eq @ B3 @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ B3 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_227_ord__eq__le__subst,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( ord @ B3 @ ( type2 @ B3 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( A2
            = ( F @ B ) )
         => ( ( ord_less_eq @ B3 @ B @ C )
           => ( ! [X2: B3,Y4: B3] :
                  ( ( ord_less_eq @ B3 @ X2 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_228_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B: A,F: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A2 @ B )
         => ( ( ord_less_eq @ C3 @ ( F @ B ) @ C )
           => ( ! [X2: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y4 )
                 => ( ord_less_eq @ C3 @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ C3 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_229_order__subst1,axiom,
    ! [A: $tType,B3: $tType] :
      ( ( ( order @ B3 @ ( type2 @ B3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B3 > A,B: B3,C: B3] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B ) )
         => ( ( ord_less_eq @ B3 @ B @ C )
           => ( ! [X2: B3,Y4: B3] :
                  ( ( ord_less_eq @ B3 @ X2 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_230_le__fun__def,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ( ( ord_less_eq @ ( A > B3 ) )
        = ( ^ [F2: A > B3,G2: A > B3] :
            ! [X: A] : ( ord_less_eq @ B3 @ ( F2 @ X ) @ ( G2 @ X ) ) ) ) ) ).

% le_fun_def
thf(fact_231_le__funI,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ! [F: A > B3,G: A > B3] :
          ( ! [X2: A] : ( ord_less_eq @ B3 @ ( F @ X2 ) @ ( G @ X2 ) )
         => ( ord_less_eq @ ( A > B3 ) @ F @ G ) ) ) ).

% le_funI
thf(fact_232_le__funE,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ! [F: A > B3,G: A > B3,X3: A] :
          ( ( ord_less_eq @ ( A > B3 ) @ F @ G )
         => ( ord_less_eq @ B3 @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funE
thf(fact_233_le__funD,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( ord @ B3 @ ( type2 @ B3 ) )
     => ! [F: A > B3,G: A > B3,X3: A] :
          ( ( ord_less_eq @ ( A > B3 ) @ F @ G )
         => ( ord_less_eq @ B3 @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funD
thf(fact_234_nat__mult__eq__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( K
          = ( zero_zero @ nat ) )
        | ( M = N ) ) ) ).

% nat_mult_eq_cancel_disj
thf(fact_235_depth__height__imp__sibling__ne,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma223349076_depth @ A @ T @ A2 )
          = ( huffma1554076246height @ A @ T ) )
       => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T ) )
         => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( huffma943100115ibling @ A @ T @ A2 )
             != A2 ) ) ) ) ) ).

% depth_height_imp_sibling_ne
thf(fact_236_linordered__field__class_Osign__simps_I35_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(35)
thf(fact_237_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type2 @ A ) )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_238_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B ) )
          = ( ord_less @ A @ A2 @ B ) ) ) ).

% add_less_cancel_left
thf(fact_239_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ C ) )
          = ( ord_less @ A @ A2 @ B ) ) ) ).

% add_less_cancel_right
thf(fact_240_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_241_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_242_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_less_double_add_iff_zero_less_single_add
thf(fact_243_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_less_zero_iff_single_add_less_zero
thf(fact_244_less__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ B @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% less_add_same_cancel2
thf(fact_245_less__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ A2 @ B ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B ) ) ) ).

% less_add_same_cancel1
thf(fact_246_add__less__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ B ) @ B )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel2
thf(fact_247_add__less__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type2 @ A ) )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ B @ A2 ) @ B )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel1
thf(fact_248_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( plus_plus @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        | ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% add_gr_0
thf(fact_249_mult__less__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% mult_less_cancel2
thf(fact_250_nat__0__less__mult__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( times_times @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        & ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% nat_0_less_mult_iff
thf(fact_251_nat__mult__less__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% nat_mult_less_cancel_disj
thf(fact_252_mult__le__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less_eq @ nat @ M @ N ) ) ) ).

% mult_le_cancel2
thf(fact_253_nat__mult__le__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less_eq @ nat @ M @ N ) ) ) ).

% nat_mult_le_cancel_disj

%----Type constructors (39)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( preorder @ A7 @ ( type2 @ A7 ) )
     => ( preorder @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( order @ A7 @ ( type2 @ A7 ) )
     => ( order @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( ord @ A7 @ ( type2 @ A7 ) )
     => ( ord @ ( A6 > A7 ) @ ( type2 @ ( A6 > A7 ) ) ) ) ).

thf(tcon_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__monoid__add__imp__le,axiom,
    ordere516151231imp_le @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors__cancel,axiom,
    semiri1923998003cancel @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Oordered__comm__semiring,axiom,
    ordere1490568538miring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Oordered__semiring__0,axiom,
    ordered_semiring_0 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Oordered__semiring,axiom,
    ordered_semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__mult,axiom,
    semigroup_mult @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring,axiom,
    comm_semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_1,axiom,
    preorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder_2,axiom,
    order @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring,axiom,
    semiring @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_3,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_4,axiom,
    ! [A6: $tType] : ( preorder @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_5,axiom,
    ! [A6: $tType] : ( order @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_6,axiom,
    ! [A6: $tType] : ( ord @ ( set @ A6 ) @ ( type2 @ ( set @ A6 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_8,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_9,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $false @ X3 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $true @ X3 @ Y )
      = X3 ) ).

%----Conjectures (4)
thf(conj_0,hypothesis,
    huffma1050891809istent @ a @ t ).

thf(conj_1,hypothesis,
    member @ a @ a2 @ ( huffma505251170phabet @ a @ t ) ).

thf(conj_2,hypothesis,
    ( ( huffma854352999e_freq @ a @ t @ a2 )
    = ( plus_plus @ nat @ w_a @ w_b ) ) ).

thf(conj_3,conjecture,
    ( ( huffma691733767weight @ a @ ( huffma454997449itLeaf @ a @ t @ w_a @ a2 @ w_b @ b ) )
    = ( huffma691733767weight @ a @ t ) ) ).

%------------------------------------------------------------------------------
